<?php

/**
 * Reviewer Plugin v.3.23.0
 * Created by Michele Ivani
 */

class RWP_Review_Count_Shortcode
{
	// Instace of this class
	protected static $instance = null;

	protected $shortcode_tag = 'rwp_review_count';

	protected $plugin_slug = 'reviewer';

	function __construct()
	{
		add_shortcode($this->shortcode_tag, array($this, 'render'));
	}

	public function render($atts)
	{
		// Shortcode attributes.	
		extract(shortcode_atts(array(
			'wrap' => 'yes'
		), $atts));

		$wrap = $wrap == 'yes';
		$count = $this->get_review_count();

		ob_start();
		echo $wrap ? '<span class="rwp-global-review-count">' . $count . '</span>' : $count;
		return ob_get_clean();
	}

	public function get_review_count()
	{
		global $wpdb;

		$result = $wpdb->get_results("SELECT * FROM $wpdb->postmeta WHERE meta_key LIKE 'rwp_rating%';", ARRAY_A);

		$count = 0;

		foreach ($result as $meta) {
			$review = maybe_unserialize($meta['meta_value']);

			// Checks
			if (!isset($review['rating_id'])) { // $meta does not contain user review
				continue;
			}
			if (isset($review['rating_status']) && $review['rating_status'] != 'published') { // The users review was not approved yet
				continue;
			}

			$count++;
		}

		return $count;
	}

	public static function get_instance()
	{
		// If the single instance hasn't been set, set it now.
		if (null == self::$instance) {
			self::$instance = new self;
		}

		return self::$instance;
	}
}
